// AddCH.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "AddCH.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAddCH dialog


CAddCH::CAddCH(CWnd* pParent /*=NULL*/)
	: CDialog(CAddCH::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddCH)
	m_FirstName = _T("");
	m_LastName = _T("");
	m_Age = _T("");
	m_Country = _T("");
	m_DOB = _T("");
	m_Phno = _T("");
	m_Street = _T("");
	m_state = _T("");
	
	//}}AFX_DATA_INIT
}

CAddCH ::CAddCH(IApplication *pApp):CDialog(CAddCH::IDD, NULL)
{
	pApplication = pApp;
	varPhoto.vt = VT_NULL;
	varSignature.vt = VT_NULL;
	
	pCardHolder.CreateInstance(__uuidof(CardHolder));
	
}
void CAddCH::DoDataExchange(CDataExchange* pDX)
	{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddCH)
	DDX_Control(pDX, IDC_NFTLIST, m_NftList);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_SUBACCTLIST, m_SubAcctList);
	DDX_Text(pDX, IDC_FNAME, m_FirstName);
	DDX_Text(pDX, IDC_LNAME, m_LastName);
	DDX_Text(pDX, IDC_NF_AGE, m_Age);
	DDX_Text(pDX, IDC_NF_CONTURY, m_Country);
	DDX_Text(pDX, IDC_NF_DOB, m_DOB);
	DDX_Text(pDX, IDC_NF_PH, m_Phno);
	DDX_Text(pDX, IDC_NF_ST, m_Street);
	DDX_Text(pDX, IDC_NF_STATE, m_state);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAddCH, CDialog)
	//{{AFX_MSG_MAP(CAddCH)
	ON_BN_CLICKED(IDADD, OnAdd)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_SUBACCTLIST, OnSelchangeSubAcctlist)
	ON_BN_CLICKED(ID_PHOTO, OnPhoto)
	ON_BN_CLICKED(ID_SIG, OnSig)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddCH message handlers
BOOL CAddCH::OnInitDialog() 
{
	CDialog::OnInitDialog();
	LoadAccounts(); // load account details in WP-CS system
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
void CAddCH :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		m_AcctList.ResetContent();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				
				m_AcctList.SetItemData(m_AcctList.AddString(pAccount->AccountName),pAccount->AccountID);
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_AcctList.SetCurSel(0);
}

void CAddCH :: LoadSubAccounts()
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
				
		//select AccountID
		int index_Acct = m_AcctList.GetCurSel();		
		long lAccountID = m_AcctList.GetItemData(index_Acct);	

		if(lAccountID <= 0)
		{
			AfxMessageBox(L"Select Account!");
			return;
		}
		pApplication->GetSubAccountsByAccountID(lAccountID, &vSubAccounts); // get account details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0, lBound ;
		IAccount *pSubAccount= NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		sa.GetLBound(1,&lBound);
		UpdateData(TRUE);
		for(long i =lBound ;i <= uBound ; i++)		
		{			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount!= NULL)
			{				
				m_SubAcctList.SetItemData(m_SubAcctList.AddString(pSubAccount->AccountName), pSubAccount->AccountID);
				pSubAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	
	//m_AccountList.SetCurSel(0);
	
}


void CAddCH::OnAdd() 
{
		BSTR bstrAcctName;
		BSTR bstrSubAcctName;
		BSTR bstrFirstName;
		BSTR bstrLastName;
		BSTR bstrAge,bstrDob,bstrstreet,bstrCountry,bstrstate,bstrPhno;


		UpdateData(TRUE);
		//select account name 
		int index_Account = m_AcctList.GetCurSel();
		CString sAcctName;
		if (index_Account <0)
			bstrAcctName = SysAllocString(L"");
		else
		{
			m_AcctList.GetLBText(index_Account,sAcctName);
			bstrAcctName = sAcctName.AllocSysString();
		}
		
		//select Sub account name 
		int index_SubAccount = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		if (index_SubAccount <0)
			bstrSubAcctName = SysAllocString(L"");
		else
		{
			m_SubAcctList.GetLBText(index_SubAccount,sSubAcctName);
			bstrSubAcctName = sSubAcctName.AllocSysString();
		}
		
		//get the CHfirstname and Last name
		bstrFirstName	= m_FirstName.AllocSysString();
		bstrLastName	= m_LastName.AllocSysString();
		//get Notefiedls Values;
		bstrDob			= m_DOB.AllocSysString();
		bstrAge			= m_Age.AllocSysString();
		bstrstreet		= m_Street.AllocSysString();
		bstrCountry		= m_Country.AllocSysString();
		bstrstate		= m_state.AllocSysString();
		bstrPhno		= m_Phno.AllocSysString();
	//set CH properties
		pCardHolder->AccountName= bstrAcctName;
		pCardHolder->FirstName= bstrFirstName;
		pCardHolder->LastName= bstrLastName;
		pCardHolder->SubAccountName= bstrSubAcctName;
	//put notefields with NFT 
		pCardHolder->NoteField["#AGE!"]=bstrAge;
		pCardHolder->NoteField["D.O.B"]=bstrDob;
		pCardHolder->NoteField["Street's Name"]=bstrstreet;
		pCardHolder->NoteField["Country"] =bstrCountry;
		pCardHolder->NoteField["Salary $$"]=bstrstate;
		pCardHolder->NoteField["Ph.No"]=bstrPhno; 
	//WPACT-1002 -> Can try above code or the one given below if notefield indexing is known
		/*for(int nfcount=0;nfcount<6 && nfcount<m_Nfnames.GetSize();nfcount++)
		{
			switch(nfcount)
			{
				case 0:
					pCardHolder->NoteField[m_Nfnames.GetAt(0).AllocSysString()]= bstrDob;
					break;
				case 1:
					pCardHolder->NoteField[m_Nfnames.GetAt(1).AllocSysString()]= bstrAge;
					break;
				case 2:
					pCardHolder->NoteField[m_Nfnames.GetAt(2).AllocSysString()]= bstrstreet;
					break;
				case 3:
					pCardHolder->NoteField[m_Nfnames.GetAt(3).AllocSysString()]= bstrCountry;
					break;
				case 4:
					pCardHolder->NoteField[m_Nfnames.GetAt(4).AllocSysString()]= bstrstate;
					break;
				case 5:
					pCardHolder->NoteField[m_Nfnames.GetAt(5).AllocSysString()]= bstrPhno;
					break;
			}
		}		*/		
		
	//add Card holder
		long lStatus;
		pApplication->AddCardHolder(pCardHolder,&lStatus);
		
		if ( lStatus == 301)
		{
			AfxMessageBox(L"Invalid Cardholder Firsrname / Lastname");
			return;
		}
		if ( lStatus == 302)
		{
			AfxMessageBox(L"Invalid Cardholder Firsrname / Lastname String Length");
			return;
		}
		
		if (lStatus == 105)
		{
			AfxMessageBox(L"InValidAccountName");
			return;
		}
		if ( lStatus == 1)
		{
			AfxMessageBox(L"CardHolder Addition Failed");
			return;
		}

		if (lStatus == 0)
		{
			long lCHID = pCardHolder->CardHolderID; // get the card holder id 
			CString sCHID;
			sCHID.Format(L"%ld",lCHID);
			CString csCHID = "CardHolderID:";
			CString outID = csCHID + sCHID;
			AfxMessageBox(outID);

			//add photo to cardholder
			if (varPhoto.vt !=VT_NULL)
			{
				//varPhoto.vt =VT_NULL;
				pCardHolder->Photo[1]=varPhoto;
				
			}
		//add signature to CH
			if (varSignature.vt !=VT_NULL)
			{
				pCardHolder->Signature[1]=varSignature;
			}

			AfxMessageBox(L"CardHolder Addition Succeded");
			CDialog::OnOK();
		}

}

void CAddCH :: GetNFtemplateDetails()
{
		BSTR bstrAcctName;	
		//select account name 
		int index_Account = m_AcctList.GetCurSel();
		CString sAcctName;
		CString sNFname, sNFMask, sCon;
		if (index_Account <0)
			bstrAcctName = SysAllocString(L"");
		else
		{
			m_AcctList.GetLBText(index_Account,sAcctName);
			bstrAcctName = sAcctName.AllocSysString();
		}

		//select Sub account name 
		BSTR bstrSubAcctName;
		int index_SubAccount = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		if (index_SubAccount <0)
			bstrSubAcctName = SysAllocString(L"");
		else
		{
			m_SubAcctList.GetLBText(index_SubAccount,sSubAcctName);
			bstrSubAcctName = sSubAcctName.AllocSysString();
		}

		_variant_t vnfts;
		vnfts.Clear();
		//get note field tempalte detaisl os specified account
		pApplication->GetNoteFieldTemplateDetailsByAccount(bstrAcctName, bstrSubAcctName, &vnfts);

		if(vnfts.vt == VT_EMPTY || vnfts.parray->rgsabound->cElements == 0)
		{
			AfxMessageBox(L"No Notefield templates in selected account");
			return;
		}
				
		long uBound =0 ;
		INoteField *pNFT = NULL;
		
		COleSafeArray sa(vnfts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_INoteField,(void**)&pNFT);
			if (pNFT != NULL)
			{
				sNFname = (LPCSTR) pNFT->NoteFieldName;
				
				sNFMask	= (LPCSTR) pNFT->FieldDefinition;
				sCon	= sNFname + _T("[") + sNFMask + _T("]");
				m_NftList.AddString(sCon);
				m_Nfnames.Add(sNFname);
				pNFT->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
}

void CAddCH::OnSelchangeAcctlist() 
{
	m_NftList.ResetContent();
	m_Nfnames.RemoveAll();
	m_SubAcctList.ResetContent();
	LoadSubAccounts();
	
}

void CAddCH::OnSelchangeSubAcctlist() 
{
	m_NftList.ResetContent();
	m_Nfnames.RemoveAll();
	
	GetNFtemplateDetails();
	
}

void CAddCH::OnPhoto() 
{
	CFileDialog Dlg(TRUE,NULL,NULL,OFN_HIDEREADONLY,_T("Pictures (*.jpg)|*.jpg||"),this);
	
	if (Dlg.DoModal()!=IDOK){
		return;
	}
	COleSafeArray safeArray;
	// Open the file
	CString sPathName = Dlg.GetPathName();
	CFile File;
	if(File.Open(sPathName,CFile::shareDenyWrite|CFile::modeRead,NULL))
	{
		// Resize the database structure to hold the image
		long Length= static_cast<long>(File.GetLength());
		 safeArray.CreateOneDim( VT_UI1, Length );

		// This kind of blows-- I have to write the data out one
		// byte at a time.  To make things a little faster,
		// read the file into memory;

		BYTE *theContents = new BYTE[Length];
		File.Read( theContents, Length );
		for (long i = 0; i < Length; ++i )
		{
			safeArray.PutElement( &i, &(theContents[i]) );
		}

		delete[] theContents;
		varPhoto = safeArray.Detach();
		// Close the file
		File.Close();
	}
    
}

void CAddCH::OnSig() 
{
	CFileDialog Dlg(TRUE,NULL,NULL,OFN_HIDEREADONLY,_T("Signature (*.sig)|*.sig|Enhanced Metafile (*.emf)|*.emf||"),this);
	
	if (Dlg.DoModal()!=IDOK){
		return;
	}
	COleSafeArray safeArray;
	// Open the file
	CString sPathName = Dlg.GetPathName();
	CFile File;
	if(File.Open(sPathName,CFile::shareDenyWrite|CFile::modeRead,NULL))
	{
		// Resize the database structure to hold the image
		long Length= static_cast<long>(File.GetLength());
		 safeArray.CreateOneDim( VT_UI1, Length );

		// This kind of blows-- I have to write the data out one
		// byte at a time.  To make things a little faster,
		// read the file into memory;

		BYTE *theContents = new BYTE[Length];
		File.Read( theContents, Length );
		for (long i = 0; i < Length; ++i )
		{
			safeArray.PutElement( &i, &(theContents[i]) );
		}

		delete[] theContents;
		varSignature = safeArray.Detach();
		// Close the file
		File.Close();
	}	
	
}
